/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import openblocks.common.tileentity.TileEntityPaintMixer;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityPaintMixerRenderer
extends FastTESR<TileEntityPaintMixer> {
    protected static BlockRendererDispatcher blockRenderer;

    public void renderTileEntityFast(TileEntityPaintMixer te, double x, double y, double z, float partialTick, int breakStage, VertexBuffer renderer) {
        if (te.hasPaint()) {
            IExtendedBlockState exState;
            if (!te.hasCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null)) {
                return;
            }
            if (blockRenderer == null) {
                blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            }
            BlockPos pos = te.func_174877_v();
            ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177227_a().contains(Properties.StaticProperty)) {
                state = state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(false));
            }
            if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)(state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos))).getUnlistedNames().contains(Properties.AnimationProperty)) {
                float time = Animation.getWorldTime((World)this.func_178459_a(), (float)partialTick);
                Pair pair = ((IAnimationStateMachine)te.getCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null)).apply(time);
                IBakedModel model = blockRenderer.func_175023_a().func_178125_b(exState.getClean());
                exState = exState.withProperty(Properties.AnimationProperty, pair.getLeft());
                renderer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
                blockRenderer.func_175019_b().func_178267_a((IBlockAccess)world, model, (IBlockState)exState, pos, renderer, false);
            }
        }
    }
}

