/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockGrave;
import openblocks.common.tileentity.TileEntityGrave;
import openmods.OpenMods;
import openmods.geometry.Hitbox;
import openmods.geometry.IHitboxSupplier;
import openmods.geometry.Orientation;
import openmods.utils.BlockUtils;
import org.lwjgl.opengl.GL11;

public class TileEntityGraveRenderer
extends TileEntitySpecialRenderer<TileEntityGrave> {
    private final IHitboxSupplier textBoxes = OpenMods.proxy.getHitboxes(OpenBlocks.location("grave_text"));

    public void renderTileEntityAt(TileEntityGrave target, double x, double y, double z, float partialTicks, int destroyStage) {
        FontRenderer renderer = this.func_147498_b();
        if (renderer != null) {
            Hitbox box;
            BlockPos pos = target.func_174877_v();
            ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)target.func_145831_w(), (BlockPos)pos);
            IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
            if (state.func_177230_c() instanceof BlockGrave && (box = this.selectBox((Boolean)state.func_177229_b(BlockGrave.HAS_BASE))) != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                GL11.glRotatef((float)BlockUtils.getRotationFromOrientation((Orientation)target.getOrientation()), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                String username = target.getUsername();
                float boxWidth = (float)(box.to.field_72450_a - box.from.field_72450_a);
                int stringWidth = renderer.func_78256_a(username);
                float textScale = boxWidth / (float)stringWidth;
                textScale = Math.min(textScale, 0.02f);
                float textX = (float)((box.to.field_72450_a + box.from.field_72450_a) / 2.0 - (double)((float)stringWidth * textScale / 2.0f));
                float textY = (float)((box.to.field_72448_b + box.from.field_72448_b) / 2.0 + (double)((float)renderer.field_78288_b * textScale / 2.0f));
                float textZ = 1.0f - (float)((box.to.field_72449_c + box.from.field_72449_c) / 2.0) + 0.001f;
                GL11.glTranslatef((float)textX, (float)textY, (float)textZ);
                GL11.glScalef((float)textScale, (float)textScale, (float)textScale);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179132_a((boolean)false);
                renderer.func_78276_b(username, 0, 0, 0);
                GlStateManager.func_179132_a((boolean)true);
                GL11.glPopMatrix();
            }
        }
    }

    private Hitbox selectBox(boolean hasBase) {
        return (Hitbox)this.textBoxes.asMap().get(hasBase ? "with_base" : "without_base");
    }
}

