/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item.stencil;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.client.renderer.TextureUploader;
import openblocks.client.renderer.item.stencil.StencilableBitmap;
import openblocks.common.IStencilPattern;
import openmods.Log;
import openmods.utils.io.BufferedResourceWrapper;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;

public class StencilTextureManager {
    public static final StencilTextureManager INSTANCE = new StencilTextureManager();
    private final Map<ResourceLocation, TexturePool> pools = Maps.newHashMap();

    private StencilTextureManager() {
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        for (TexturePool pool : this.pools.values()) {
            pool.allocate(evt.getMap());
        }
    }

    public StencilTextureManager register(ResourceLocation background, int size) {
        TexturePool newPool = new TexturePool(size, background);
        TexturePool prev = this.pools.put(background, newPool);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate value for entry '%s'", (Object[])new Object[]{background});
        return this;
    }

    public ResourceLocation getStencilTextureLocation(ResourceLocation background, IStencilPattern pattern) {
        TexturePool texturePool = this.pools.get(background);
        Preconditions.checkState((texturePool != null ? 1 : 0) != 0, (Object)"Pool for '%' not registered");
        return texturePool.get(pattern);
    }

    public ResourceLocation getEmptyStencilTextureLocation(ResourceLocation background) {
        TexturePool texturePool = this.pools.get(background);
        Preconditions.checkState((texturePool != null ? 1 : 0) != 0, (Object)"Pool for '%' not registered");
        return texturePool.getPrimer();
    }

    private static class TexturePool {
        private final int size;
        private final ResourceLocation background;
        private PoolPrimerTexture primerTexture;
        private final Deque<PoolTexture> freeLocations = Queues.newArrayDeque();
        private final Map<IStencilPattern, PoolTexture> usedLocations = Maps.newHashMap();

        public TexturePool(int size, ResourceLocation background) {
            this.size = size;
            this.background = background;
        }

        private static ResourceLocation getResourceLocation(TextureMap map, ResourceLocation location) {
            return new ResourceLocation(location.func_110624_b(), String.format("%s/%s.png", map.getBasePath(), location.func_110623_a()));
        }

        public void allocate(TextureMap textureMap) {
            int mipmapLevels = textureMap.getMipmapLevels();
            ResourceLocation backgroundFullLocation = TexturePool.getResourceLocation(textureMap, this.background);
            ResourceLocation primerLocation = new ResourceLocation(this.background.func_110624_b(), this.background.func_110623_a() + "-primer");
            this.primerTexture = new PoolPrimerTexture(mipmapLevels, primerLocation, backgroundFullLocation);
            textureMap.setTextureEntry((TextureAtlasSprite)this.primerTexture);
            this.freeLocations.clear();
            for (int i = 0; i < this.size; ++i) {
                ResourceLocation newLocation = new ResourceLocation(this.background.func_110624_b(), this.background.func_110623_a() + "-" + i);
                PoolTexture pooledSprite = new PoolTexture(newLocation, this.primerTexture, mipmapLevels);
                this.freeLocations.push(pooledSprite);
                textureMap.setTextureEntry((TextureAtlasSprite)pooledSprite);
            }
            this.usedLocations.clear();
        }

        public ResourceLocation get(IStencilPattern pattern) {
            PoolTexture result = this.usedLocations.get(pattern);
            if (result != null) {
                return result.selfLocation;
            }
            result = this.freeLocations.poll();
            if (result == null) {
                Log.warn((String)"No more textures in pool for %s, returning blank one", (Object[])new Object[]{this.background});
                return this.primerTexture.selfLocation;
            }
            result.loadPattern(pattern);
            this.usedLocations.put(pattern, result);
            return result.selfLocation;
        }

        public ResourceLocation getPrimer() {
            return this.primerTexture.selfLocation;
        }
    }

    private static class PoolTexture
    extends TextureAtlasSprite
    implements TextureUploader.IUploadableTexture {
        private final ResourceLocation selfLocation;
        private final PoolPrimerTexture primer;
        private final int mipmapLevels;
        private boolean requiresUpload;

        private PoolTexture(ResourceLocation selfLocation, PoolPrimerTexture primer, int mipmapLevels) {
            super(selfLocation.toString());
            this.selfLocation = selfLocation;
            this.primer = primer;
            this.mipmapLevels = mipmapLevels;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        private void copyTextureDataFromPrimer() {
            this.func_130103_l();
            this.field_110976_a.add(this.primer.func_147965_a(0));
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            if (!this.primer.isLoaded) {
                this.primer.load(manager);
            }
            this.field_130223_c = this.primer.func_94211_a();
            this.field_130224_d = this.primer.func_94216_b();
            this.copyTextureDataFromPrimer();
            return false;
        }

        public void func_147963_d(int level) {
            Preconditions.checkArgument((level == this.mipmapLevels ? 1 : 0) != 0, (String)"Mismatched mipmap levels: %s -> %s", (Object[])new Object[]{level, this.mipmapLevels});
            this.primer.func_147963_d(level);
            this.copyTextureDataFromPrimer();
        }

        public void loadPattern(IStencilPattern pattern) {
            this.func_130103_l();
            int[][] mipmaps = new int[this.mipmapLevels + 1][];
            mipmaps[0] = this.primer.bitmap.apply(pattern);
            this.field_110976_a.add(mipmaps);
            super.func_147963_d(this.mipmapLevels);
            this.requiresUpload = true;
            TextureUploader.INSTANCE.scheduleTextureUpload(this);
        }

        @Override
        public void upload() {
            if (this.requiresUpload) {
                this.requiresUpload = false;
                TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(0)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        }
    }

    private static class PoolPrimerTexture
    extends TextureAtlasSprite {
        private final ResourceLocation resourceLocation;
        private final int mipmapLevels;
        private boolean isLoaded;
        private final ResourceLocation selfLocation;
        private StencilableBitmap bitmap;

        private PoolPrimerTexture(int mipmapLevels, ResourceLocation selfLocation, ResourceLocation resourceLocation) {
            super(selfLocation.toString());
            this.selfLocation = selfLocation;
            this.mipmapLevels = mipmapLevels;
            this.resourceLocation = resourceLocation;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            this.load(manager);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(IResourceManager manager) {
            block4: {
                if (this.isLoaded) break block4;
                BufferedResourceWrapper backgroundTexture = null;
                try {
                    backgroundTexture = new BufferedResourceWrapper(manager.func_110536_a(this.resourceLocation));
                    InputStream is = backgroundTexture.func_110527_b();
                    is.mark(0);
                    PngSizeInfo sizeInfo = new PngSizeInfo((InputStream)new CloseShieldInputStream(is));
                    super.func_188538_a(sizeInfo, false);
                    is.reset();
                    super.func_188539_a((IResource)backgroundTexture, this.mipmapLevels + 1);
                }
                catch (Exception e) {
                    try {
                        Log.warn((Throwable)e, (String)"Failed to load stencil base texture: %s", (Object[])new Object[]{this.resourceLocation});
                        FMLClientHandler.instance().trackMissingTexture(this.resourceLocation);
                        this.field_130224_d = 16;
                        this.field_130223_c = 16;
                        int[][] mipmaps = new int[this.mipmapLevels + 1][];
                        mipmaps[0] = TextureUtil.field_110999_b;
                        this.func_130103_l();
                        this.field_110976_a.add(mipmaps);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(backgroundTexture);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)backgroundTexture);
                }
                IOUtils.closeQuietly((Closeable)backgroundTexture);
                this.bitmap = new StencilableBitmap(((int[][])this.field_110976_a.get(0))[0], this.field_130223_c);
                this.isLoaded = true;
            }
        }

        private boolean isMipmapped() {
            Iterator iterator = this.field_110976_a.iterator();
            while (iterator.hasNext()) {
                int[][] frame;
                for (int[] mipmap : frame = (int[][])iterator.next()) {
                    if (mipmap != null) continue;
                    return false;
                }
            }
            return true;
        }

        public void func_147963_d(int level) {
            Preconditions.checkArgument((level == this.mipmapLevels ? 1 : 0) != 0, (String)"Mismatched mipmap levels: %s -> %s", (Object[])new Object[]{level, this.mipmapLevels});
            if (!this.isMipmapped()) {
                super.func_147963_d(level);
            }
        }
    }
}

