/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.List;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.EmptyComposite;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.GuiComponentHBox;
import openmods.gui.component.GuiComponentHCenter;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.page.BookScaleConfig;
import openmods.gui.component.page.PageBase;
import openmods.utils.TranslationUtils;

public class ChangelogPage
extends PageBase {
    private static final Function<String, String> BULLET_TRANSFORMER = new Function<String, String>(){

        public String apply(String value) {
            return "\u00b7" + value;
        }
    };
    final GuiComponentLabel prevVersionLabel;
    final GuiComponentLabel nextVersionBookmark;

    public ChangelogPage(String currentVersion, String section, List<String> lines) {
        float scaleTitle = BookScaleConfig.getPageTitleScale();
        float scaleContent = BookScaleConfig.getPageContentScale();
        int lineSpace = BookScaleConfig.getTitlePageSeparator();
        section = TranslationUtils.translateToLocal((String)section);
        GuiComponentLabel currentVersionLabel = new GuiComponentLabel(0, 0, section).setScale(scaleTitle);
        this.addComponent((BaseComponent)new GuiComponentHCenter(0, 24, this.getWidth()).addComponent((BaseComponent)currentVersionLabel));
        GuiComponentHBox titleLine = new GuiComponentHBox(0, 0);
        this.prevVersionLabel = new GuiComponentLabel(0, 2, "");
        this.prevVersionLabel.setScale(BookScaleConfig.getPageContentScale());
        titleLine.addComponent((BaseComponent)this.prevVersionLabel);
        titleLine.addComponent((BaseComponent)new EmptyComposite(0, 0, 0, 7));
        GuiComponentLabel centerVersionLabel = new GuiComponentLabel(0, 0, currentVersion);
        centerVersionLabel.setScale(scaleTitle);
        titleLine.addComponent((BaseComponent)centerVersionLabel);
        titleLine.addComponent((BaseComponent)new EmptyComposite(0, 0, 0, 7));
        this.nextVersionBookmark = new GuiComponentLabel(0, 2, "");
        this.nextVersionBookmark.setScale(BookScaleConfig.getPageContentScale());
        titleLine.addComponent((BaseComponent)this.nextVersionBookmark);
        this.addComponent((BaseComponent)new GuiComponentHCenter(0, 12, this.getWidth()).addComponent((BaseComponent)titleLine));
        String contents = Joiner.on((char)'\n').join(Iterables.transform(lines, BULLET_TRANSFORMER));
        GuiComponentLabel lblContent = new GuiComponentLabel(15, 40, this.getWidth() - 10, this.getHeight(), contents);
        lblContent.setScale(scaleContent);
        lblContent.setAdditionalLineHeight(lineSpace);
        this.addComponent((BaseComponent)lblContent);
    }

    void setPrevVersionBookmark(GuiComponentBook book, String name, int page) {
        this.prevVersionLabel.setText("\u00a77" + name);
        this.prevVersionLabel.setListener(book.createBookmarkListener(page));
    }

    void setNextVersionBookmark(GuiComponentBook book, String name, int page) {
        this.nextVersionBookmark.setText("\u00a77" + name);
        this.nextVersionBookmark.setListener(book.createBookmarkListener(page));
    }
}

