import { Component, OnInit } from '@angular/core';
import { GlobalVariable } from '../GlobalVariables';
import { Router } from "@angular/router";
import { MatDialog } from "@angular/material/dialog";
import { AuthConnexion } from '../_connexions/auth.connexion';
import { SessionStorageService } from '../_session/session.service';
import { UserSchema } from '../_schemas/user.schema';
import { FunctionService } from '../_session/function.service';

@Component({
  selector: 'app-sign-up',
  templateUrl: './sign-up.component.html',
  styleUrls: ['./sign-up.component.css']
})
export class SignUpComponent {
  UserConnectee : string = "Anonymous";
  
  constructor(
    public dialog: MatDialog, 
    public glob: GlobalVariable, 
    public session: SessionStorageService,
    public auth: AuthConnexion,
    public fonction: FunctionService,
    private route:Router
    ) {}

  public IsLogged = false;
  public userName = 'Anonymous';
  public message = 'No API Found';
  public failure = false;
  public success = false;
  private user?: UserSchema;
  public formulaire: any = {nom: '', prenom: '', email: '', telephone: '', password: ''};
  
  ngOnInit(): void {
    this.IsLogged = this.session.LoggedChecker('UserSession');

    if(this.IsLogged){
      this.user = this.session.get('UserSession');
      this.userName = this.user?.nom?.toUpperCase() + ' ' + this.fonction.capitalizeFirstLetter(this.user?.prenom)
      this.glob.userName = this.userName;
      this.route.navigateByUrl('/Home')
    }
  }  

  ngOnSubmit(): void {
    this.auth.signup(this.formulaire.nom,this.formulaire.prenom,this.formulaire.telephone,this.formulaire.email, this.formulaire.password).subscribe({
        next: (result: any) => {
            this.success = true;
            this.message = result.message;
        },
        error: (msgError : any) => {
            this.failure = true;
            this.message = msgError.statusText;
        }
    });
  }
}

