import { Component, OnInit } from '@angular/core';
import { GlobalVariable } from '../GlobalVariables';
import { Router } from "@angular/router";
import { MatDialog } from "@angular/material/dialog";
import { AuthConnexion } from '../_connexions/auth.connexion';
import { SessionStorageService } from '../_session/session.service';
import { UserSchema } from '../_schemas/user.schema';
import { FunctionService } from '../_session/function.service';

@Component({
  selector: 'app-sign-in',
  templateUrl: './sign-in.component.html',
  styleUrls: ['./sign-in.component.css']
})

export class SignInComponent implements OnInit {

  UserConnectee : string = "Anonymous";
  
  constructor(
    public dialog: MatDialog, 
    public glob: GlobalVariable, 
    public session: SessionStorageService,
    public auth: AuthConnexion,
    public fonction: FunctionService,
    private route:Router
    ) {}

  public IsLogged = false;
  public userName = 'Anonymous';
  public messageError = 'No API Found';
  public failure = false;
  private user?: UserSchema;
  public formulaire: any = {email: '', password: ''};
  
  ngOnInit(): void {
    this.IsLogged = this.session.LoggedChecker('UserSession');

    if(this.IsLogged){
      this.user = this.session.get('UserSession');
      this.userName = this.user?.nom?.toUpperCase() + ' ' + this.fonction.capitalizeFirstLetter(this.user?.prenom)
      this.glob.userName = this.userName;
    }
  }  

  ngOnSubmit(): void {
    this.auth.signin(this.formulaire.email, this.formulaire.password).subscribe({
        next: (result: any) => {
            this.session.save('UserSession', result.user);
            this.IsLogged = true;
            this.failure = false;
            location.reload();
        },
        error: (msgError : any) => {
            this.failure = true;
            if(msgError.statusText)
              this.messageError = msgError.statusText;
        }
    });
  }
}
