import { Component, OnInit } from '@angular/core';
import { GlobalVariable } from '../GlobalVariables';
import { Router } from "@angular/router";
import { MatDialog } from "@angular/material/dialog";
import { UserConnexion } from '../_connexions/user.connexion';
import { SessionStorageService } from '../_session/session.service';
import { UserSchema } from '../_schemas/user.schema';
import { FunctionService } from '../_session/function.service';

@Component({
  selector: 'app-modification-compte',
  templateUrl: './modification-compte.component.html',
  styleUrls: ['./modification-compte.component.css']
})
export class ModificationCompteComponent {
  UserConnectee : string = "Anonymous";
  
  constructor(
    public dialog: MatDialog, 
    public glob: GlobalVariable, 
    public session: SessionStorageService,
    public connexion: UserConnexion,
    public fonction: FunctionService,
    private route:Router
    ) {}

  public IsLogged = false;
  public userName = 'Anonymous';
  public message = 'No API Found';
  public failure = false;
  public success = false;
  private user?: UserSchema;
  public formulaire: any = {nom: '', prenom: '', email: '', telephone: '', password: ''};
  
  ngOnInit(): void {
    this.IsLogged = this.session.LoggedChecker('UserSession');

    if(this.IsLogged){
      this.user = this.session.get('UserSession');
      this.userName = this.user?.nom?.toUpperCase() + ' ' + this.fonction.capitalizeFirstLetter(this.user?.prenom)
      this.glob.userName = this.userName;
      this.formulaire.nom = this.user?.nom;
      this.formulaire.prenom = this.user?.prenom;
      this.formulaire.email = this.user?.email;
      this.formulaire.telephone = this.user?.telephone;
    }
    else{
      this.route.navigateByUrl('/Home')
    }
  }

  ngOnSubmit(): void {
    this.connexion.update(this.user?.id, this.formulaire).subscribe({
        next: (result: any) => {
            this.success = true;
            this.message = result.message;
            this.session.save('UserSession', result.User);
        },
        error: (msgError : any) => {
            this.failure = true;
            this.message = msgError.statusText + ": " + msgError.error.message;
        }
    });
  }
}
