import { Component } from '@angular/core';
import { Router } from "@angular/router";
import { RoleService } from '../_session/role.service';
import { SessionStorageService } from '../_session/session.service';
import { GlobalVariable } from '../GlobalVariables';
import { UserSchema } from '../_schemas/user.schema';
import { FunctionService } from '../_session/function.service';

@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.css']
})

export class HomeComponent {

  constructor(
    public glob: GlobalVariable, 
    public session: SessionStorageService,
    public service: RoleService,
    public fonction: FunctionService,
    private route:Router
    ) {}

  public IsLogged = false;
  public IsEtudiant = false;
  public IsEnseignant = false;
  public IsAdmin = false;
  public userName = 'Anonymous';
  public message = 'Bienvenue sur Edukation, commencez par vous créer un compte ou vous connecter!';
  private user?: UserSchema;

  ngOnInit(): void {
    this.IsLogged = this.session.LoggedChecker('UserSession');

    if(this.IsLogged){
      this.user = this.session.get('UserSession');
      this.userName = this.user?.nom?.toUpperCase() + ' ' + this.fonction.capitalizeFirstLetter(this.user?.prenom)
      this.glob.userName = this.userName;
      this.route.navigateByUrl('/Home')
    }

    this.IsAdmin = this.service.AdminChecker('UserSession');
    if(this.IsAdmin)
      this.message='Bienvenue à vous Admin ' + this.userName + ", qu'allons nous faire aujourd'hui?";
    this.IsEnseignant = this.service.EnseignantChecker('UserSession');
    if(this.IsEnseignant)
      this.message='Bienvenue à vous Enseignant ' + this.userName + ", quel programme allez-vous préparer pour vos cours?";
    this.IsEtudiant = this.service.EtudiantChecker('UserSession');
    if(this.IsEtudiant)
      this.message='Bienvenue à vous ' + this.userName + ", qu'allez-vous étudier aujourd'hui?";
  }  
}