import { Component, OnInit } from '@angular/core';
import { GlobalVariable } from './GlobalVariables';
import { Router } from "@angular/router";
import { MatDialog } from "@angular/material/dialog";
import { AuthConnexion } from './_connexions/auth.connexion';
import { SessionStorageService } from './_session/session.service';
import { UserSchema } from './_schemas/user.schema';
import { SignInComponent } from './sign-in/sign-in.component';
import { FunctionService } from './_session/function.service';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})

export class AppComponent implements OnInit {

  UserConnectee : string = "Anonymous";
  
  constructor(
    public dialog: MatDialog, 
    public glob: GlobalVariable, 
    public session: SessionStorageService,
    public auth: AuthConnexion,
    public fonction: FunctionService,
    private route:Router
    ) {}

  public IsLogged = false;
  public userName = 'Anonymous';
  private user?: UserSchema;
  
  ngOnInit(): void {
    this.route.navigateByUrl('/Home');
    this.IsLogged = this.session.LoggedChecker('UserSession');
    if(this.IsLogged){
      this.user = this.session.get('UserSession');
      this.userName = this.user?.nom?.toUpperCase() + ' ' + this.fonction.capitalizeFirstLetter(this.user?.prenom)
      this.glob.userName = this.userName;
    }
  }  

  signOut() : void {
    this.auth.signout().subscribe({
      next: result => {
        this.session.clear();
        location.reload();
        console.log(result);
      },
      error: msgError => {
        console.log(msgError);
      }
    });
  }

  signIn() {
    this.dialog.open(SignInComponent, {
      width: "35vw"
    })
  }
}
