import { Injectable } from '@angular/core';

@Injectable(
    {providedIn: 'root'}
)
export class SessionStorageService {
  constructor() {}

  // Méthode pour sauvegarder une valeur dans la session
  public save(key: string, value: any): void {
    sessionStorage.setItem(key, JSON.stringify(value));
  }

  // Méthode pour récupérer une valeur de la session
  public get(key: string): any {
    const value = sessionStorage.getItem(key);
    return value ? JSON.parse(value) : null;
  }

  // Méthode pour supprimer une valeur de la session
  public remove(key: string): void {
    sessionStorage.removeItem(key);
  }

  // Méthode pour vider entièrement la session
  public clear(): void {
    sessionStorage.clear();
  }

  public LoggedChecker(key: string): boolean {
    const UserSession = sessionStorage.getItem(key);
    if (UserSession) {
      return true;
    }
    return false;
  }
}
