import { Injectable } from '@angular/core';

@Injectable(
    {providedIn: 'root'}
)
export class RoleService {
  constructor() {}

  public AdminChecker(key: string): boolean {
    const AdminSession = sessionStorage.getItem(key);
    if (AdminSession) {
      let compteAdmin = JSON.parse(AdminSession);
      return compteAdmin.roles.some((nameRole: string) => nameRole === "Admin")
    }
    return false;
  }

  public EnseignantChecker(key: string): boolean {
    const EnseignantSession = sessionStorage.getItem(key);
    if (EnseignantSession) {
      let compteEnseignant = JSON.parse(EnseignantSession);
      return compteEnseignant.roles.some((nameRole: string) => nameRole === "Enseignant")
    }
    return false;
  }

  public EtudiantChecker(key: string): boolean {
    const EtudiantSession = sessionStorage.getItem(key);
    if (EtudiantSession) {
      let compte = JSON.parse(EtudiantSession);
      return compte.roles.some((nameRole: string) => nameRole === "Etudiant")
    }
    return false;
  }
}
