import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';

import { userSkillSchema } from '../_schemas/userSkill.schema';

const URL = 'http://localhost:8080/api/userSkill';

@Injectable({
  providedIn: 'root'
})
export class SkillConnexion {

  constructor(private HTTP: HttpClient) { }

  // Find Users skills link with a project
  public findByProject(id: any): Observable<userSkillSchema[]> {
    return this.HTTP.get<userSkillSchema[]>(URL + '/' + id);
  }

  // Find Users skills link with a skill
  public findBySkill(id: any): Observable<userSkillSchema[]> {
    return this.HTTP.get<userSkillSchema[]>(URL + '/skill/' + id);
  }

  // Find Projects link with a user
  public update(body: any): Observable<any> {
    return this.HTTP.put(URL + '/update/', body);
  }
}
