import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';

import { userProjectSchema } from '../_schemas/userProject.schema';

const URL = 'http://localhost:8080/api/userProject';

@Injectable({
  providedIn: 'root'
})
export class userProjectConnexion {

  constructor(private HTTP: HttpClient) { }

  // Find Users link with a project
  public findByProject(id: any): Observable<userProjectSchema[]> {
    return this.HTTP.get<userProjectSchema[]>(URL + '/project/' + id);
  }

  // Find Projects link with a user
  public findByUser(id: any): Observable<userProjectSchema[]> {
    return this.HTTP.get<userProjectSchema[]>(URL + '/user/' + id);
  }
}
