import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';

import { UserSchema } from '../_schemas/user.schema';
import { ProjectSchema } from '../_schemas/project.schema';

const URL = 'http://localhost:8080/api/user';


@Injectable({
  providedIn: 'root'
})
export class UserConnexion {

  constructor(private HTTP: HttpClient) { }

  // Find all Users
  public findAll(): Observable<UserSchema[]> {
    return this.HTTP.get<UserSchema[]>(URL + '/');
  }

  // Find one User
  public findOne(id: any): Observable<UserSchema> {
    return this.HTTP.get<UserSchema>(URL + '/' + id);
  }

  // Update a User
  public update(id: any, body: any): Observable<any> {
    return this.HTTP.put(URL + '/' + id, body);
  }

  // Delete a User
  public delete(id: any): Observable<any> {
    return this.HTTP.delete(URL + '/' + id);
  }

  // Find all projects affected to an User
  public findAffectedProjects(): Observable<ProjectSchema[]> {
    return this.HTTP.get<ProjectSchema[]>(URL + '/find/projects');
  }
}
