import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';

import { SkillSchema } from '../_schemas/skill.schema';

const URL = 'http://localhost:8080/api/skill';

@Injectable({
  providedIn: 'root'
})
export class SkillConnexion {

  constructor(private HTTP: HttpClient) { }

  // Find all skills
  public findAll(): Observable<SkillSchema[]> {
    return this.HTTP.get<SkillSchema[]>(URL + '/');
  }

  // Find alls skills for a project
  public findAllbyProject(id: any): Observable<SkillSchema[]> {
    return this.HTTP.get<SkillSchema[]>(URL + '/project/' + id);
  }

  // Find one skill
  public findOne(id: any): Observable<SkillSchema> {
    return this.HTTP.get<SkillSchema>(URL + '/' + id);
  }

  // Update a skill
  public update(id: any, body: any): Observable<any> {
    return this.HTTP.put(URL + '/' + id, body);
  }

  // Delete a skill in a project
  public delete(id: any): Observable<any> {
    return this.HTTP.delete(URL + '/' + id);
  }

  // Create a skill in a project
  public create(body: any): Observable<any> {
    return this.HTTP.post(URL + '/create', body);
  }
}
