import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';

import { ProjectSchema } from '../_schemas/project.schema';

const URL = 'http://localhost:8080/api/project';

@Injectable({
  providedIn: 'root'
})
export class ProjectConnexion {

  constructor(private HTTP: HttpClient) { }

  // Find all projects
  public findAll(): Observable<ProjectSchema[]> {
    return this.HTTP.get<ProjectSchema[]>(URL + '/');
  }

  // Find a specific project by ID
  public findOne(id: any): Observable<ProjectSchema> {
    return this.HTTP.get<ProjectSchema>(URL + '/' + id);
  }

  // Register for a project
  public registerToProject(id: any): Observable<any> {
    return this.HTTP.get<any>(URL + '/affectation/' + id);
  }

  // Update a project
  public update(id: any, body: any): Observable<any> {
    return this.HTTP.put(URL + '/' + id, body);
  }

  // Delete a project
  public delete(id: any): Observable<any> {
    return this.HTTP.delete(URL + '/' + id);
  }

  // Create a new project
  public create(body: any): Observable<any> {
    return this.HTTP.post(URL + '/create', body);
  }
}
