import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';

const URL = 'http://localhost:8080/api/auth/';

const httpOptions = {
  headers: new HttpHeaders({ 'Content-Type': 'application/json' })
};

@Injectable({
  providedIn: 'root',
})
export class AuthConnexion {
  constructor(private HTTP: HttpClient) { }

  // User signin
  signin(email: string, password: string): Observable<any> {
    return this.HTTP.post(
      URL + 'signin', // API endpoint for user signin
      { email, password }, // Request body containing email and password
      httpOptions // HTTP headers
    );
  }

  // User signup
  signup(
    nom: string,
    prenom: string,
    telephone: string,
    email: string,
    password: string
  ): Observable<any> {
    return this.HTTP.post(
      URL + 'signup', // API endpoint for user signup
      { nom, prenom, telephone, email, password }, // Request body containing user details
      httpOptions // HTTP headers
    );
  }

  // User signout
  signout(): Observable<any> {
    return this.HTTP.post(
      URL + 'signout', // API endpoint for user signout
      {}, // Empty request body
      httpOptions // HTTP headers
    );
  }
}
