// Import required modules
const express = require("express"); // Express framework
const cors = require("cors"); // Cross-Origin Resource Sharing
const cookieSession = require("cookie-session"); // Cookie session handling

var bcrypt = require("bcryptjs");

// Initialize Express application
const app = express();

// Import database models
const db = require("./models/index");
const Role = db.role; // Role model
const User = db.user; // User model

// Configure CORS options
var corsOptions = {
    origin: "http://localhost:4200", // Allowed origin
    credentials: true // Enable credentials
};

// Connect to the database
db.mongoose
    .connect(db.url, {
        useNewUrlParser: true,
        useUnifiedTopology: true
    })
    .then(() => {
        console.log("Connected to the database!");
        initial(); // Perform initial setup
    })
    .catch(err => {
        console.log("Unable to connect to the database!", err);
        process.exit(); // Exit the process if unable to connect
    });

// Use CORS middleware with configured options
app.use(cors(corsOptions));

// Parse JSON request bodies
app.use(express.json());

// Parse URL-encoded request bodies
app.use(express.urlencoded({ extended: true }));

// Configure cookie session
app.use(
    cookieSession({
        name: "UPJV-autoEvaluation", // Session name
        secret: "vF5tD6634WsxcX", // Session secret key
        httpOnly: true // Only allow HTTP access to the session cookie
    })
);

// Import routes
require("./routes/auth.routes")(app);
require("./routes/project.routes")(app);
require("./routes/skill.routes")(app);
require("./routes/user.routes")(app);
require("./routes/userProject.routes")(app);
require("./routes/userSkill.routes")(app);
require("./routes/role.routes")(app);

// Set the server port
const PORT = process.env.PORT || 8080;

// Start the server
app.listen(PORT, () => {
    console.log(`Server running on port ${PORT}.`);
});

// Define a route for the API home
app.get("/api/", (req, res) => {
    res.json({ message: "API Home" });
});

// Perform initial setup (create default roles and admin user if not present)
async function initial() {
    await Role.estimatedDocumentCount().then(data => {
        if (data === 0) {
            // If no roles exist in the database, create default roles
            for (let role of db.ROLES) {
                new Role({
                    nom: role // Role name
                })
                    .save()
                    .then(data => {
                        console.log("Role '" + role + "' added to 'roles' collection");
                    })
                    .catch(err => {
                        console.log("Error when adding to collection '" + role + "': ", err);
                    });
            }
        }
    }).catch(err => {
        console.error("Error occurred: " + err.message);
    });

    await User.estimatedDocumentCount().then(data => {
        if (data === 0) {
            // If no users exist in the database, create admin user
            const user = new User({
                nom: "admin", // Admin user's name
                prenom: "admin", // Admin user's last name
                email: "admin@admin.com", // Admin user's email
                telephone: '0000', // Admin user's telephone number
                password: bcrypt.hashSync("adminedukation1234", 10), // Hash the password // Admin user's password
            });

            Role.find({ nom: "Admin" }).then(roles => {
                // Find the "Admin" role
                user.roles = roles.map((role) => role._id);
                user.save().then(data => {
                    console.log("Admin user added to 'user' collection");
                }).catch(err => {
                    console.log("Error when adding admin to 'user' collection");
                });
            });
        }
    }).catch(err => {
        console.error("Error occurred: " + err.message);
    });
}
