module.exports = app => {
  const userSkill = require("../controllers/userSkill.controller"); // Import user skill controller
  const {middleware} = require("../middlewares/index"); // Import middlewares

  var router = require("express").Router(); // Create an instance of the Express Router

  // Set Access-Control-Allow-Headers header
  app.use(function(req, res, next) {
      res.header(
          "Access-Control-Allow-Headers",
          "Origin, Content-Type, Accept"
      );
      next();
  });
  
  // Define route to find user skills by project ID
  router.get("/:idProject", [middleware.getToken], userSkill.findByProject);

  // Define route to find user skills by skill ID
  router.get("/skill/:idSkill", [middleware.getToken], userSkill.findBySkill);

  // Define route to update user skills
  router.put("/update/", [middleware.getToken, middleware.needTagEtudiant], userSkill.update);

  // Mount the router on the "/api/userSkill" path
  app.use("/api/userSkill", router);
};
