module.exports = app => {
  const userProject = require("../controllers/userProject.controller"); // Import user project controller
  const {middleware} = require("../middlewares/index"); // Import middlewares

  var router = require("express").Router(); // Create an instance of the Express Router

  // Set Access-Control-Allow-Headers header
  app.use(function(req, res, next) {
      res.header(
          "Access-Control-Allow-Headers",
          "Origin, Content-Type, Accept"
      );
      next();
  });

  // Define route to find user projects by project ID
  router.get("/project/:idProject", [middleware.getToken], userProject.findByProject);

  // Define route to find user projects by user ID
  router.get("/user/:idUser/", [middleware.getToken], userProject.findByUser);

  // Mount the router on the "/api/userProject" path
  app.use("/api/userProject", router);
};
