module.exports = app => {
  const users = require("../controllers/user.controller"); // Import user controller
  const { middleware } = require("../middlewares/index"); // Import middlewares

  var router = require("express").Router(); // Create an instance of the Express Router

  // Set Access-Control-Allow-Headers header
  app.use(function (req, res, next) {
    res.header(
      "Access-Control-Allow-Headers",
      "Origin, Content-Type, Accept"
    );
    next();
  });

  // Define route to get all users
  router.get("/", [middleware.getToken], users.findAll);

  // Define route to get a specific user by ID
  router.get("/:id", [middleware.getToken, middleware.needTagAdmin], users.findOne);

  // Define route to update a user by ID
  router.put("/:id", [middleware.getToken], users.update);

  // Define route to delete a user by ID
  router.delete("/:id", [middleware.getToken, middleware.needTagAdmin], users.delete);

  // Define route to find users assigned to projects
  router.get("/find/projects", [middleware.getToken], users.findAffectToProject);

  // Mount the router on the "/api/user" path
  app.use("/api/user", router);
};
