module.exports = app => {
  const skills = require("../controllers/skill.controller"); // Import skill controller
  const {middleware} = require("../middlewares/index"); // Import middlewares

  var router = require("express").Router(); // Create an instance of the Express Router

  // Set Access-Control-Allow-Headers header
  app.use(function(req, res, next) {
      res.header(
          "Access-Control-Allow-Headers",
          "Origin, Content-Type, Accept"
      );
      next();
  });
  
  // Define route to get all skills
  router.get("/", [middleware.getToken], skills.findAll);

  // Define route to get all skills by project ID
  router.get("/project/:id", [middleware.getToken], skills.findAllbyProject);

  // Define route to get a specific skill by ID
  router.get("/:id", [middleware.getToken], skills.findOne);

  // Define route to update a skill by ID
  router.put("/:id", [middleware.getToken, middleware.needTagEnseignant, middleware.isOwnerProject, middleware.checkSameSkillProject], skills.update);

  // Define route to delete a skill by ID
  router.delete("/:id", [middleware.getToken, middleware.needTagEnseignant, middleware.isOwnerProject], skills.delete);

  // Define route to create a new skill
  router.post("/create", [middleware.getToken, middleware.needTagEnseignant, middleware.isOwnerCreateProject, middleware.checkSameSkillProject], skills.create);

  // Mount the router on the "/api/skill" path
  app.use("/api/skill", router);
};
