module.exports = app => {
  const projects = require("../controllers/project.controller"); // Import project controller
  const { middleware } = require("../middlewares/index"); // Import middlewares

  var router = require("express").Router(); // Create an instance of the Express Router

  // Set Access-Control-Allow-Headers header
  app.use(function (req, res, next) {
    res.header(
      "Access-Control-Allow-Headers",
      "Origin, Content-Type, Accept"
    );
    next();
  });

  // Define route to get all projects
  router.get("/", [middleware.getToken], projects.findAll);

  // Define route to get a specific project by ID
  router.get("/:id", [middleware.getToken], projects.findOne);

  // Define route to register to a project
  router.get(
    "/affectation/:id",
    [middleware.getToken, middleware.needTagEtudiant, middleware.notAffected],
    projects.registerToProject
  );

  // Define route to update a project by ID
  router.put("/:id", [middleware.getToken, middleware.needTagEnseignant], projects.update);

  // Define route to delete a project by ID
  router.delete("/:id", [middleware.getToken, middleware.needTagEnseignant], projects.delete);

  // Define route to create a new project
  router.post(
    "/create",
    [middleware.getToken, middleware.needTagEnseignant, middleware.checkProjectName],
    projects.create
  );

  // Mount the router on the "/api/project" path
  app.use("/api/project", router);
};
