// Import required modules
const { middleware } = require("../middlewares/index");
const controller = require("../controllers/auth.controller");

// Export a function that sets up authentication routes
module.exports = function(app) {
  // Set response headers to allow specific types of requests
  app.use(function(req, res, next) {
    res.header(
      "Access-Control-Allow-Headers",
      "Origin, Content-Type, Accept"
    );
    next();
  });

  // Route for user signup
  app.post("/api/auth/signup", [middleware.checkDuplicatedMail, middleware.checkRoleExist], controller.signup);

  // Route for user signout
  app.post("/api/auth/signout", controller.signout);

  // Route for user signin
  app.post("/api/auth/signin", controller.signin);
};
