module.exports = (mongoose, Skill) => {
    // Define the schema for UserSkill collection
    var schema = mongoose.Schema({
      idSkill: {
        type: mongoose.Schema.Types.ObjectId,
        ref: "Skill",
      },
      idUser: {
        type: mongoose.Schema.Types.ObjectId,
        ref: "User",
      },
      note: String,
    });
  
    // Add a method called "toJSON" to the schema
    schema.method("toJSON", async function () {
      // Destructure the object, excluding "__v" and "_id" fields
      const { __v, _id, ...object } = this.toObject();
  
      // Find the Skill object referenced by idSkill and convert it to JSON
      let ThisSkill = await Skill.findById(object.idSkill);
      object.idSkill = ThisSkill.toJSON();
  
      object.id = _id; // Assign _id to id property in the object
      return object; // Return the modified object
    });
  
    // Create and return the UserSkill model using the schema
    const UserSkill = mongoose.model("UserSkill", schema);
    return UserSkill;
  };
  