module.exports = mongoose => {
  // Define the schema for UserProject collection
  var schema = mongoose.Schema({
    idUser: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
    },
    idProject: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Project",
    },
    status: String,
  });

  // Add a method called "toJSON" to the schema
  schema.method("toJSON", function () {
    // Destructure the object, excluding "__v" and "_id" fields
    const { __v, _id, ...object } = this.toObject();

    object.id = _id; // Assign _id to id property in the object
    return object; // Return the modified object
  });

  // Create and return the UserProject model using the schema
  const UserProject = mongoose.model("UserProject", schema);
  return UserProject;
};
