module.exports = (mongoose, userProject) => {
  // Define the schema for User collection
  var schema = mongoose.Schema({
    nom: String,
    prenom: String,
    telephone: String,
    email: String,
    password: String,
    roles: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: "Role",
      },
    ],
  });

  // Add a pre-hook to the schema's "deleteOne" operation
  schema.pre("deleteOne", { document: false, query: true }, async function (next) {
    try {
      const userId = this.getQuery()["_id"];
      await userProject.deleteMany({ idUser: userId });
      next();
    } catch (err) {
      next(err);
    }
  });

  // Add a method called "toJSON" to the schema
  schema.method("toJSON", function () {
    // Destructure the object, excluding "__v" and "_id" fields
    const { __v, _id, ...object } = this.toObject();

    var authorities = [];
    for (let i = 0; i < object.roles.length; i++) {
      authorities.push(object.roles[i].nom);
    }
  
    object.id = _id;
    delete object.password;
    object.roles = authorities;

    return object; // Return the modified object
  });
  
  // Add a method called "needAdmin" to the schema
  schema.method("needAdmin", function() {
    // Destructure the object, excluding "__v" and "_id" fields
    const { __v, _id, ...object } = this.toObject();

    let isAdmin = false;

    for(let role of object.roles) {
      if(role.nom === "Admin")
        isAdmin = true;
    }
    
    return isAdmin; // Return whether the user has an "Admin" role
  });

  // Create and return the User model using the schema
  const User = mongoose.model("User", schema);
  return User;
};
