module.exports = (mongoose) => {
  // Define the schema for Skill collection
  var schema = mongoose.Schema({
    nom: String,
    description: String,
    idProject: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Project",
    },
  });

  // Add a method called "toJSON" to the schema
  schema.method("toJSON", function () {
    // Destructure the object, excluding "__v" and "_id" fields
    const { __v, _id, ...object } = this.toObject();

    object.id = _id; // Assign _id to id property in the object
    return object; // Return the modified object
  });

  // Create and return the Skill model using the schema
  const Skill = mongoose.model("Skill", schema);
  return Skill;
};
