module.exports = (mongoose, UserProject) => {
  // Define the schema for Project collection
  var schema = mongoose.Schema({
    nom: String,
    description: String,
  });

  // Add a method called "toJSON" to the schema
  schema.method("toJSON", async function () {
    // Destructure the object, excluding "__v" and "_id" fields
    const { __v, _id, ...object } = this.toObject();

    object.id = _id; // Assign _id to id property in the object
    return object; // Return the modified object
  });

  // Add a pre-hook to the schema's "deleteOne" operation
  schema.pre("deleteOne", { document: false, query: true }, async function (next) {
    try {
      const projectId = this.getQuery()["_id"];
      await UserProject.deleteMany({ idProject: projectId });
      next();
    } catch (err) {
      next(err);
    }
  });

  // Create and return the Project model using the schema
  const Project = mongoose.model("Project", schema);
  return Project;
};
