// Import required modules and configuration
const dbConfig = require("../config/all.config");
const mongoose = require("mongoose");

// Set the default promise library to the global promise library
mongoose.Promise = global.Promise;

// Create an empty object to hold the database models and configuration
const db = {};

// Assign the mongoose object and database URL to the db object
db.mongoose = mongoose;
db.url = dbConfig.url;

// Require and initialize the database models
db.role = require("./role.model.js")(mongoose);
db.userProject = require("./userProject.model.js")(mongoose);
db.user = require("./user.model.js")(mongoose, db.userProject);
db.skill = require("./skill.model.js")(mongoose);
db.userSkill = require("./userSkill.model")(mongoose, db.skill);
db.project = require("./project.model.js")(mongoose, db.userProject);

// Assign the roles from the configuration to the db object
db.ROLES = dbConfig.roles;

// Export the db object as the module's public API
module.exports = db;
