const jwt = require("jsonwebtoken");
const config = require("../config/all.config.js");
const db = require("../models/index.js");

const ROLES = db.ROLES;
const User = db.user;
const Role = db.role;
const Skill = db.skill;
const Project = db.project;
const UserProject = db.userProject;

var Cookies = require("cookies");

isOwnerCreateProject = (req, res, next) => {
    // Check 'idProject' field
    if (!req.body.idProject) {
        return res.status(400).send({ message: "Related id Project is required." });
    }
    if (!req.body.idProject.match(/^[0-9a-fA-F]{24}$/)) {
        // No, it's not a valid ObjectId.
        return res.status(404).send({ message: "Bad format of Object ID!" });
    }
    UserProject.find({idUser : req.userId, idProject : req.body.idProject, status : "Owner"})
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        })
        
        .then(data => {
            console.log(data)
            if(data.length == 0 ) {
                res.status(400).send({ message: "You aren't the owner of the project!" });
                return;
            }
            next();
        });
};

isOwnerProject = async (req, res, next) => {
    let skill = await Skill.findById(req.params.id);
    console.log(skill);
    if(skill == null)
    {
        res.status(400).send({ message: "No skill found!" });
        return;
    }
    await UserProject.find({idUser : req.userId, idProject : skill.idProject, status : "Owner"})
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        })
        
        .then(data => {
            console.log(data)
            if(data.length == 0 ) {
                res.status(400).send({ message: "You aren't the owner of the project!" });
                return;
            }
            next();
        });
};

checkSameSkillProject = (req, res, next) => {
    // Check 'idProject' field
    if (!req.body.idProject) {
        return res.status(400).send({ message: "Related id Project is required." });
    }
    // Check 'nom' field
    if (!req.body.nom) {
        return res.status(400).send({ message: "Name Skill is required." });
    }
    if (!req.body.idProject.match(/^[0-9a-fA-F]{24}$/)) {
        // No, it's not a valid ObjectId.
        return res.status(404).send({ message: "Bad format of Object ID!" });
    }
    Skill.find({idProject : req.body.idProject, nom : req.body.nom})
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        })
        
        .then(data => {
            if(data.length != 0 ) {
                res.status(400).send({ message: "This skill already exists for this project" });
                return;
            }
            next();
        });
};

notAffected = (req, res, next) => {
    if (req.params.id.match(/^[0-9a-fA-F]{24}$/)) {
        UserProject.find({idUser : req.userId, idProject : req.params.id})
            .catch(error => { 
                res.status(500).send({ message: error });
                return;
            })
            .then(data => {
                if(data) {
                    res.status(400).send({ message: "Already register for this project!" });
                    return;
                }
                next();
            });
        }
        else{
            res.status(400).send({ message: "Not a good project Id to give!" });
                    return;
        }
};

checkProjectName = (req, res, next) => {
    Project.find({nom : req.body.nom})
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        })
        .then(data => {
            if(data.length != 0 ) {
                res.status(400).send({ message: "Project Name already taken!" });
                return;
            }
            next();
        });
};

needTagEtudiant = (req, res, next) => {
    User.findById(req.userId)
        .populate("roles", "-__v")
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        })
        .then(user => { 
            for (let role of user.roles) {
                if (role.nom === "Etudiant" || user.needAdmin()) { 
                    next();
                    return;
                }
            }
            res.status(403).send({ message: "Needed Etudiant Tag!" });
            return;
        })
        .catch(error => {
            res.status(500).send({ message: error });
            return;
        });
};

needTagEnseignant = (req, res, next) => {
    User.findById(req.userId) 
        .populate("roles", "-__v")
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        })
        .then(user => { 
            for (let role of user.roles) {
                if (role.nom === "Enseignant" || user.needAdmin()) { 
                    next();
                    return;
                }
            }
            res.status(403).send({ message: "Need Enseignant Tag!" });
            return;
        })
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        });
};

needTagAdmin = (req, res, next) => {
    User.findById(req.userId) 
        .populate("roles", "-__v")
        .catch(error => { 
            res.status(500).send({ message: error });
            return;
        })
        .then(user => { 
            for (let role of user.roles) {
                if (role.nom === "Admin") { 
                    next();
                    return;
                }
            }
            res.status(403).send({ message: "Need Tag Admin!" });
            return;
        });
};

getToken = (req, res, next) => {
    //let token = new Cookies(req,res).get('access_token');
    let token = req.session.token;
    if (!token) { 
        return res.status(403).send({ message: "No Token found!" });
    }

    jwt.verify(token, config.token, (err, decoded) => {
        if (err) { 
            return res.status(401).send({ message: "No authorization!" });
        }
        req.userId = decoded.id;
        next(); 
    });
};

checkDuplicatedMail = (req, res, next) => {
    User.findOne({
        email: req.body.email
    }).then(data => {
        if(data) {
            res.status(400).send({ message: "Mail already taken!" });
            return;
        }
        next();
    }).catch(error => {
        res.status(500).send({ message: error });
        return;
    });
};

checkRoleExist = (req, res, next) => {
    if (req.body.roles) {
        for (let i = 0; i < req.body.roles.length; i++) {
            if (!ROLES.includes(req.body.roles[i])) {
                res.status(400).send({
                    message: `Failed! Role ${req.body.roles[i]} does not exist!`
                });
                return;
            }
        }
    }

    next();
};

const middleware = {
    isOwnerProject,
    isOwnerCreateProject,
    checkSameSkillProject,
    notAffected,
    checkProjectName,
    getToken,
    needTagAdmin,
    needTagEnseignant,
    needTagEtudiant,
    checkDuplicatedMail,
    checkRoleExist
};

module.exports = middleware;