const db = require("../models/index");
const UserProject = db.userProject;
const Project = db.project;
const User = db.user;

// Find user projects associated with a project
exports.findByProject = async (req, res) => {
    if (!req.params.idProject.match(/^[0-9a-fA-F]{24}$/)) {
        // No, it's not a valid ObjectId.
        return res.status(404).send({ message: "Bad format of Object ID!" });
    }
    const filter = { idProject: req.params.idProject };

    UserProject.find(filter)
        .then(async data => {
            let listeUserProject = [];

            for (let userProject of data) {
                // Find the User document based on the idUser in UserProject
                await User.findById(userProject.idUser)
                    .populate("roles", "-__v")
                    .then(user => {
                        listeUserProject.push({ user: user.toJSON(), status: userProject.status });
                    })
                    .catch(err => {
                        res.status(500).send({ message: "Unable to retrieve requested information!" });
                    });
            }

            res.send(listeUserProject);
        })
        .catch(err => {
            res.status(500).send({ message: "Unable to retrieve requested information!" });
        });
};

// Find user projects associated with a user
exports.findByUser = async (req, res) => {
    if (!req.params.idUser.match(/^[0-9a-fA-F]{24}$/)) {
        // No, it's not a valid ObjectId.
        return res.status(404).send({ message: "Bad format of Object ID!" });
    }

    const filter = { idUser: req.params.idUser };

    UserProject.find(filter)
        .then(async data => {
            let listeUserProject = [];

            for (let userProject of data) {
                // Find the Project document based on the idProject in UserProject
                await Project.findById(userProject.idProject)
                    .then(async project => {
                        listeUserProject.push({ project: await project.toJSON(), status: userProject.status });
                    })
                    .catch(err => {
                        res.status(500).send({ message: "Unable to retrieve requested information!" });
                    });
            }

            res.send(listeUserProject);
        })
        .catch(err => {
            res.status(500).send({ message: "Unable to retrieve requested information!" });
        });
};
