const db = require("../models/index");
const Role = db.role;

// Find all projects
exports.findAll = async (req, res) => {
    try {
        const data = await Role.find();

        const roles = await Promise.all(
            data.map(async (project) => {
                return await project.toJSON();
            })
        );

        res.send(roles);
    } catch (err) {
        res.status(500).send({
            message:
                err.message || "An error occurred while retrieving the roles.",
        });
    }
};



