const config = require("../config/all.config");
const db = require("../models");
const User = db.user;
const Role = db.role;

var jwt = require("jsonwebtoken");
var Cookies = require("cookies");
var bcrypt = require("bcryptjs");

// User signup
exports.signup = (req, res) => {
   // Check 'prenom' field
   if (!req.body.prenom) {
    return res.status(400).send({ message: "First name is required." });
  }

  // Check 'nom' field
  if (!req.body.nom) {
    return res.status(400).send({ message: "Last name is required." });
  }

  // Check 'password' field
  if (!req.body.password) {
    return res.status(400).send({ message: "Password is required." });
  }

  // Check 'email' field
  if (!req.body.email) {
    return res.status(400).send({ message: "Email is required." });
  }

  // Check 'telephone' field
  if (!req.body.telephone) {
    return res.status(400).send({ message: "Phone number is required." });
  }
  
  const user = new User({
    nom: req.body.nom.trim(),
    prenom: req.body.prenom.trim(),
    email: req.body.email.trim(),
    telephone: req.body.telephone
      .replace(/ /g, "") // Remove whitespace
      .replace(".", "") // Remove dots
      .replace("-", "") // Remove dashes
      .replace("+", "") // Remove plus signs
      .match(/.{1,2}/g) // Split into groups of two digits
      .join(" "), // Join groups with whitespace
    password: bcrypt.hashSync(req.body.password, 10), // Hash the password
  });

  user
    .save()
    .then(data => {
      if (req.body.roles) {
        Role.find({
          nom: { $in: req.body.roles },
        })
          .then(roles => {
            user.roles = roles.map(role => role._id);
            user.save().catch(err => {
              res.status(500).send({ message: err });
              return;
            });

            res.send({ message: "The user has been successfully registered!" });
          });
      } else {
        Role.findOne({ nom: "Etudiant" }).then(role => {
          user.roles = [role._id];
          user.save().catch(err => {
            res.status(500).send({ message: err });
            return;
          });

          res.send({ message: "The user has been successfully registered!" });
        });
      }
    })
    .catch(err => {
      res.status(500).send({ message: err });
      return;
    });
};

// User signin
exports.signin = (req, res) => {
  User.findOne({
    email: req.body.email.trim(),
  })
    .populate("roles", "-__v")
    .then(user => {
      if (!user) {
        return res.status(404).send({ message: "User not found" });
      }

      var passwordIsValid = bcrypt.compareSync(
        req.body.password,
        user.password
      );

      if (!passwordIsValid) {
        return res.status(401).send({ message: "Invalid password!" });
      }

      var token = jwt.sign({ id: user.id }, config.token, {
        expiresIn: 10800, // 3 hours
      });

      req.session.token = token;
/*
      new Cookies(req,res).set('access_token',token, {
        httpOnly: true
      })*/

      res.status(200).send({ user: user.toJSON() });
    });
};

// User signout
exports.signout = async (req, res) => {
  try {
    req.session = null;
    return res.status(200).send({ message: "You've been disconnected!" });
  } catch (err) {
    this.next(err);
  }
};
